################################################################
#
#   Bell Runner - Screen
#
################################################################

import os, sys
from optparse import OptionParser
from pygame.locals import FULLSCREEN
from albow.resource import resource_path

screen_size = (800, 600)
fullscreen = False
flags = 0
frame_time = 50

app_version = (1, 0, 0)
app_magic = "BRun"

save_file_version = 1
save_min_version = 1
save_app_version = (1, 0, 0)
save_version_ranges = {}
save_file_magic = "SAVE"
save_file_suffix = ".brgam"
save_file_default_name = "Bell_Runner_Game"

level_file_version = 1
level_min_version = 1
level_app_version = (1, 0, 0)
level_version_ranges = {}
level_file_magic = "LEVL"
level_set_suffix = ".brset"
level_file_suffix = ".brlev"
std_level_dir_name = "levels" + level_set_suffix

# The following paths are relative to the directory containing
# the Game directory or the .app bundle.
default_save_dir_name = "Saves"
default_level_set_dir_name = "Mods"

usage = "%prog [options] [saved_game]"

options = None
macosx_bundle = False

option_defs = [
	("-f,--fullscreen", 'fullscreen',  "Run in full-screen mode"      ),
	("-w,--windowed",   'windowed',    "Run in windowed mode"         ),
	#("-s,--size",       'size',        "Window size: <width>x<height>"),
	("-n,--newgame",    'newgame',     "Start new game"),
	("-e,--edit",       'edit',        "Start in level editor"),
]

debug_options = [
]

class DefaultingOptions(object):

	def __init__(self, d):
		self.__dict__.update(d)

	def __getattr__(self, name):
		return False

def extract_macosx_finder_launch_args():
	#  When launched from the Finder under MacOSX, we get called with
	#  a command line argument of the form -psn_N_NNNNN. We set a flag
	#  to remember this and delete the argument from argv.
	global macosx_bundle
	args = sys.argv
	if len(args) > 1 and args[1].startswith("-psn_"):
		macosx_bundle = True
		del args[1]

def get_command_line_options():
	global options
	extract_macosx_finder_launch_args()
	parser = OptionParser(usage = usage)
	def add_option(flags, dest, help, type = None):
		if type:
			action = 'store'
		else:
			action = 'store_true'
		parser.add_option(action = action, dest = dest, help = help,
			type = type, *flags.split(","))
	for desc in option_defs:
		add_option(*desc)
	if os.environ.get("BR_DEBUG"):
		for desc in debug_options:
			add_option(*desc)
	opts, args = parser.parse_args()
	if args:
		opts.filename = args[0]
	else:
		opts.filename = None
	options = DefaultingOptions(opts.__dict__)
	override_default_settings(options)

def override_default_settings(options):
	global fullscreen, screen_size
	if options.fullscreen:
		fullscreen = True
	if options.windowed:
		fullscreen = False
	if fullscreen:
		flags |= FULLSCREEN
	if options.size:
		try:
			screen_size = map(int, options.size.split("x"))
			if len(screen_size) <> 2:
				raise ValueError
		except ValueError:
			fatal("Invalid --size argument")

def fatal(mess):
	sys.stderr.write("%s: %s\n" % (sys.argv[0], mess))
	sys.exit(1)

def get_program_dir():
	#  Find the directory containing the program and the default
	#  Save and Mods directories. For the MacOSX bundle version, this is
	#  the directory containing the .app bundle. For other versions,
	#  this is the directory containing the Game directory.
	d = os.path.dirname
	path = d(d(sys.path[0]))
	if macosx_bundle:
		path = d(path)
	return path
	
def get_std_level_dir():
	#  Find the directory containing the standard levels.
	return resource_path(std_level_dir_name)

def get_default_save_dir():
	parent = get_program_dir()
	return os.path.join(parent, default_save_dir_name)

def get_default_level_set_dir():
	parent = get_program_dir()
	return os.path.join(parent, default_level_set_dir_name)

def secs_to_frames(t):
	return int(round(1000.0 * t / frame_time))
