################################################################
#
#   Bell Runner - Representation of notes and pitches
#
################################################################

from albow.controls import TextField

note_chars = "efgABCDE"

#-----------------------------------------------------------------------------

class NotesField(TextField):

	upper = False
	
	def allow_char(self, c):
		return c in note_chars

#-----------------------------------------------------------------------------

def pitch_to_note(pitch):
	return note_chars[pitch]

def pitches_to_notes(pitches):
	return "".join([pitch_to_note(p) for p in pitches])
	
def note_to_pitch(note):
	return note_chars.index(note)

def notes_to_pitches(notes):
	return [note_to_pitch(c) for c in notes]
