################################################################
#
#   Bell Runner - Menu Screen
#
################################################################

from pygame.locals import *
from screen import BRScreen
from game import game

#-----------------------------------------------------------------------------

class MenuScreen(BRScreen):

	bg_color = (0, 0, 0)
	bg_image = None
	command_map = {}

	def __init__(self, shell):
		BRScreen.__init__(self, shell)
	
	def draw(self, surf):
		bg = self.bg_image
		if bg:
			r = bg.get_rect()
			r.bottomleft = (0, self.height)
			surf.blit(bg, r)

	def menu_button(self, title, action_name):
		shell = self.shell
		enable = self.enable_func(action_name)
		action = self.command_func(action_name)
		return self.button_class(title, action = action, enable = enable)

	def key_down(self, e):
		command = None
		if e.cmd or K_F1 <= e.key <= K_F10:
			command = self.command_map.get(e.key)
		if command:
			self.do_command(command)
		else:
			BRScreen.key_down(self, e)
	
	def do_command(self, command):
		if self.enable_func(command)():
			self.command_func(command)()
	
	def enable_func(self, command):
		return getattr(self.shell, command + '_enabled', always_enabled)
	
	def command_func(self, command):
		return getattr(self.shell, command, no_action)

#-----------------------------------------------------------------------------

def always_enabled():
	return True

def no_action():
	return

