################################################################
#
#   Bell Runner - Main Menu Screen
#
################################################################

from pygame.locals import *
from albow.resource import get_font, get_image
from albow.controls import Label, Column, Button
from menu_screen import MenuScreen

#title_color = (128, 255, 0)
#title_font = get_font(36, "VeraBd.ttf")
#menu_font = get_font(24, "VeraBd.ttf")

class MainMenuTitle(Label):
	pass

class MainMenuButton(Button):
	pass

class MainMenuScreen(MenuScreen):

	title_class = MainMenuTitle
	button_class = MainMenuButton
	bg_image = get_image("title_screen.jpeg")
	
	command_map = {
		K_F1: 'about',
		K_n: 'new_game',
		K_o: 'load_game',
		K_s: 'save_game',
		K_r: 'restart_level',
		K_q: 'quit',
	}

	def __init__(self, shell):
		MenuScreen.__init__(self, shell)
		title = MainMenuTitle("Bell Runner")
		mb = self.menu_button
		buttons = [
			mb("About", 'about'),
			mb("New Game", 'new_game'),
			mb("Load Game...", 'load_game'),
			mb("Save Game", 'save_game'),
			mb("Continue", 'resume_game'),
			mb("Restart Level", 'restart_level'),
			mb("Custom Levels...", 'open_level_set'),
			mb("Level Editor", 'enter_level_editor'),
			mb("Quit", 'quit'),
		]
		menu = Column(buttons, align = 'r')
		box = Column([title, menu], align = 'r', spacing = 0)
		#c = self.center
		#box.center = self.center
		box.right = self.width - 20
		box.top = 0
		self.add(box)

	def escape_key(self):
		self.do_command('resume_game')
