################################################################
#
#   Bell Runner - Level playing view
#
################################################################

from pygame.locals import *
from level_view import LevelView
from player import FACE_LEFT, FACE_RIGHT
from game import game

class LevelPlayingView(LevelView):

	def key_down(self, e):
		level = game.level
		player = level.player
		k = e.key
		if k == K_LEFT:
			player.start_walking(FACE_LEFT)
		elif k == K_RIGHT:
			player.start_walking(FACE_RIGHT)
		elif k == K_SPACE:
			player.grab_or_release_rope()
		else:
			LevelView.key_down(self, e)
	
	def key_up(self, e):
		level = game.level
		player = level.player
		k = e.key
		if k == K_LEFT:
			player.stop_walking(FACE_LEFT)
		elif k == K_RIGHT:
			player.stop_walking(FACE_RIGHT)
		else:
			LevelView.key_up(self, e)
