################################################################
#
#   Bell Runner - Editor Menu Screen
#
################################################################

from pygame.locals import *
from albow.resource import get_font, get_image
from albow.controls import Label, Column, Button
from menu_screen import MenuScreen

title_color = (255, 255, 0)
title_font = get_font(36, "VeraBd.ttf")
menu_font = get_font(24, "VeraBd.ttf")


class EditMenuTitle(Label):
	pass

class EditMenuButton(Button):
	pass

class EditMenuScreen(MenuScreen):

	bg_color = (255, 255, 255)
	title_class = EditMenuTitle
	button_class = EditMenuButton
	bg_image = get_image("editor_screen.jpeg")

	command_map = {
		K_n: 'new_level',
		K_o: 'open_level',
		K_e: 'edit_level',
		K_t: 'test_level',
		K_s: 'save_level',
		K_q: 'exit_level_editor',
	}

	def __init__(self, shell):
		MenuScreen.__init__(self, shell)
		title = EditMenuTitle("Level Editor")
		mb = self.menu_button
		buttons = [
			mb("Create Level Set...", 'create_level_set'),
			mb("New Level", 'new_level'),
			mb("Open Level...", 'open_level'),
			mb("Resume Editing", 'edit_level'),
			mb("Test Level", 'test_level'),
			mb("Save Level", 'save_level'),
			mb("Save Level As...", 'save_level_as'),
			mb("Exit Editor", 'exit_level_editor'),
		]
		menu = Column(buttons, align = 'r')
		box = Column([title, menu], align = 'r', spacing = 20)
		#c = self.center
		#box.center = self.center
		box.topright = (self.width - 20, 0)
		self.add(box)

	def escape_key(self):
		self.shell.edit_level()

