from pygame import Rect
from vectors import add, subtract

debug_rect = False

root_widget = None

class Widget(object):
	#  rect           Rect       bounds in parent's coordinates
	#  parent         Widget     containing widget
	#  subwidgets     [Widget]   contained widgets
	#  focus_switch   Widget     subwidget to receive key events
	#  bg_color       color      to fill background, or None
	
	bg_color = None

	def __init__(self, rect = None):
		self.rect = rect or Rect(0, 0, 100, 100)
		self.parent = None
		self.subwidgets = []
		self.focus_switch = None
		self.is_modal = False
	
	def add(self, widget):
		widget.set_parent(self)
	
	def remove(self, widget):
		if widget in self.subwidgets:
			widget.set_parent(None)
	
	def set_parent(self, parent):
		if parent is not self.parent:
			if self.parent:
				self.parent._remove(self)
			self.parent = parent
			if parent:
				parent._add(self)
	
	def _add(self, widget):
		self.subwidgets.append(widget)
	
	def _remove(self, widget):
		self.subwidgets.remove(widget)
		if self.focus_switch is widget:
			self.focus_switch = None
	
	def draw_all(self, surface):
		bg = self.bg_color
		if bg:
			surface.fill(bg)
		self.draw(surface)
		for widget in self.subwidgets:
			if debug_rect:
				print "Widget: Drawing subwidget %s of %s with rect %s" % (
					widget, self, widget.rect)
			sub = surface.subsurface(widget.rect)
			widget.draw_all(sub)
	
	def draw(self, surface):
		pass
	
	def find_widget(self, pos):
		for widget in self.subwidgets[::-1]:
			r = widget.rect
			if r.collidepoint(pos):
				return widget.find_widget(subtract(pos, r.topleft))
		return self
	
	def handle_mouse(self, name, event):
		event.dict['local'] = self.global_to_local(event.pos)
		self.call_handler(name, event)
	
	def dispatch_key(self, name, event):
		widget = self.focus_switch
		if widget:
			widget.dispatch_key(name, event)
		else:
			self.call_handler(name, event)

	def call_handler(self, name, *args):
		method = getattr(self, name, None)
		if method:
			method(*args)
			return True
		else:
			return False
	
	def call_parent_handler(self, name, *args):
		if not self.is_modal:
			parent = self.parent
			if parent:
				parent.call_handler(name, *args)
	
	def global_to_local(self, p):
		return subtract(p, self.local_to_global_offset())
	
	def local_to_global_offset(self):
		d = self.rect.topleft
		parent = self.parent
		if parent:
			d = add(d, parent.local_to_global_offset())
		return d

	def key_down(self, event):
		self.call_parent_handler('key_down', event)

	def is_inside(self, container):
		widget = self
		while widget:
			if widget is container:
				return True
			widget = widget.parent
		return False

	def present(self):
		#print "Widget: presenting with rect", self.rect
		root = self.get_root()
		self.rect.center = root.rect.center
		root.add(self)
		root.run(modal_widget = self)
		root.remove(self)
		#print "Widget.present: returning", self.modal_result
		return self.modal_result
	
	def dismiss(self, value):
		self.modal_result = value

	def get_root(self):
		return root_widget

	def focus(self):
		self.focus_on(None)
	
	def focus_on(self, subwidget):
		self.focus_switch = subwidget
		parent = self.parent
		if parent:
			parent.focus_on(self)

	def has_focus(self):
		return self.focused_on(None)
	
	def focused_on(self, widget):
		return self.focus_switch is widget and self.contains_focus()
	
	def contains_focus(self):
		return self.is_modal or (self.parent and self.parent.focused_on(self))
