import sys
import pygame
from pygame.locals import *
import widget
from widget import Widget

mod_cmd = KMOD_LCTRL | KMOD_RCTRL | KMOD_LMETA | KMOD_RMETA

class RootWidget(Widget):

	bg_color = (0, 0, 0)

	def __init__(self, surface):
		Widget.__init__(self, surface.get_rect())
		self.surface = surface
		widget.root_widget = self
	
	def set_timer(self, ms):
		pygame.time.set_timer(USEREVENT, ms)

	def run(self, modal_widget = None):
		modal_widget = modal_widget or self
		was_modal = modal_widget.is_modal
		modal_widget.is_modal = True
		modal_widget.modal_result = None
		mouse_widget = None
		while modal_widget.modal_result is None:
			self.draw_all(self.surface)
			pygame.display.flip()
			events = [pygame.event.wait()]
			events.extend(pygame.event.get())
			#print "Events:", events
			for event in events:
				type = event.type
				if type == QUIT:
					sys.exit(0)
				elif type == MOUSEBUTTONDOWN:
					event_widget = self.find_widget(event.pos)
					if event_widget.is_inside(modal_widget):
						mouse_widget = event_widget
						event_widget.handle_mouse('mouse_down', event)
				elif type == MOUSEMOTION:
					if mouse_widget:
						mouse_widget.handle_mouse('mouse_drag', event)
					else:
						event_widget = self.find_widget(event.pos)
						if event_widget.is_inside(modal_widget):
							event_widget.handle_mouse('mouse_move', event)
				elif type == MOUSEBUTTONUP:
					if mouse_widget:
						mouse_widget.handle_mouse('mouse_up', event)
				elif type == KEYDOWN:
					self.send_key(modal_widget, 'key_down', event)
				elif type == KEYUP:
					self.send_key(modal_widget, 'key_up', event)
				elif type == USEREVENT:
					self.begin_frame()
		modal_widget.is_modal = was_modal
	
	def send_key(self, widget, name, event):
		self.expand_mod(event, event.mod)
		#print "RootWidget.send_key:", event
		widget.dispatch_key(name, event)
	
	def expand_mod(self, event, mod):
		event.dict['cmd'] = mod & mod_cmd <> 0

	def begin_frame(self):
		pass

	def get_root(self):
		return self

	def contains_focus(self):
		return True
