import os
import pygame

default_font_name = "Vera.ttf"
optimize = True

import __main__
resource_dir = os.path.join(os.path.dirname(__main__.__file__), "resources")

image_cache = {}
font_cache = {}
sound_cache = {}

def resource_path(*names):
	return os.path.join(resource_dir, *names)

def get_image(name, border = 0):
	image = image_cache.get(name)
	if not image:
		image = pygame.image.load(resource_path("images", name))
		if optimize:
			#print "Before convert_alpha:", map(hex, image.get_masks())
			image = image.convert_alpha()
			#print "After convert_alpha:", map(hex, image.get_masks())
		if border:
			w, h = image.get_size()
			b = border
			d = 2 * border
			image = image.subsurface(b, b, w - d, h - d)
		image_cache[name] = image
	return image

def get_font(size, name = default_font_name):
	key = (name, size)
	font = font_cache.get(key)
	if not font:
		path = resource_path("fonts", name)
		font = pygame.font.Font(path, size)
		font_cache[key] = font
	return font

def get_sound(name):
	sound = sound_cache.get(name)
	if not sound:
		from pygame.mixer import Sound
		path = resource_path("sounds", name)
		sound = Sound(path)
		sound_cache[name] = sound
	return sound

default_font = get_font(12)
