from pygame import Rect
from pygame.locals import *
from widget import Widget
from controls import Label, TextField

class Dialog(Widget):

	bg_color = (128, 128, 128)

	def key_down(self, event):
		k = event.key
		if k == K_RETURN or k == K_KP_ENTER:
			self.dismiss(True)
		elif k == K_ESCAPE:
			self.dismiss(False)


#def alert(mess):
#	print "***", mess

def input_text(prompt, width, initial = None):
	def ok():
		box.dismiss(True)
	def cancel():
		box.dismiss(False)
	lb = Label(prompt)
	tf = TextField(width)
	if initial:
		tf.set_text(initial)
	tf.enter_action = ok
	tf.escape_action = cancel
	tf.rect.top = lb.rect.top
	tf.rect.left = lb.rect.right + 5
	box = Widget(Rect((0, 0), tf.rect.bottomright))
	box.add(lb)
	box.add(tf)
	box.bg_color = (128, 128, 128)
	tf.focus()
	if box.present():
		return tf.get_text()
	else:
		return None
